class X2Ability_BioticAdeptSet extends X2Ability config(GameData_SoldierSkills);

var config int WARP_COOLDOWN;

var config int LANCE_COOLDOWN;

var config int REAVE_COOLDOWN;

var config int REAVE_BASE;
var config int REAVE_BONUS;
var config int REAVE_MAG;
var config int REAVE_BEAM;

var config int SINGULARITY_COOLDOWN;
var config int SINGULARITY_RANGE;
var config int SINGULARITY_RADIUS;
var config int SINGULARITY_MINRADIUS;
var config int SINGULARITY_MAXRADIUS;
var config float SINGULARITY_PSIMULTI;

var config int Exposure_Rupture;

var privatewrite name 	EndSingularityDurationFXEventName;
var privatewrite name	SingularityDurationFXEffectName;

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Templates;

	Templates.AddItem(Warp()); //warps a designated target. Can not bypass shields and armour, but has a shorter cooldown compared to Soulfire. Also ruptures a target for +2/+4/+6 damage.
	Templates.AddItem(Lance()); //squadsight-capable power that can miss, but shreds armour.
	Templates.AddItem(Reave()); //converts an enemy's HP to bonus shield points. Only affects organic enemies.
	Templates.AddItem(PurePassive('RM_ExposingBiotics', "img:///XPerkIconPack.UIPerk_crit_psi", false, 'eAbilitySource_Psionic')); //All combat abilities that don't normally rupture enemies now do for +2.
	Templates.AddItem(PurePassive('RM_ConsumingBiotics', "img:///XPerkIconPack.UIPerk_adrenaline_x2", false, 'eAbilitySource_Psionic')); // All biotic abilities that aren't reave provide a shield point when used.
	//Templates.AddItem(UncannyAccuracy()); //Biotic gains +20 aim;
	Templates.AddItem(Singularity()); //Ruptures all targets in an area for +6 damage, pulls them out of cover.
	Templates.AddItem(SingularityEndDurationFX()); 
	Templates.AddItem(PurePassive('RM_DevastatingBiotics', "img:///XPerkIconPack.UIPerk_enemy_crit_chevron_x3", false, 'eAbilitySource_Psionic')); //All biotic abilities, including Singularity and Annihilaition Field now do bonus damage.


	return Templates;
}

//
//static function X2AbilityTemplate UncannyAccuracy()
//{
	//local X2AbilityTemplate                 Template;	
	//local X2AbilityTrigger					Trigger;
	//local X2AbilityTarget_Self				TargetStyle;
	//local X2Effect_PersistentStatChange		PersistentStatChangeEffect;
//
	//`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_UncannyAccuracy');
	//Template.IconImage = "img:///gfxXComIcons.psi_telekineticfield";
//
	//Template.AbilitySourceName = 'eAbilitySource_Perk';
	//Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	//Template.Hostility = eHostility_Neutral;
	//Template.bDisplayInUITacticalText = false;
	//
	//Template.AbilityToHitCalc = default.DeadEye;
	//
	//TargetStyle = new class'X2AbilityTarget_Self';
	//Template.AbilityTargetStyle = TargetStyle;
//
	//Trigger = new class'X2AbilityTrigger_UnitPostBeginPlay';
	//Template.AbilityTriggers.AddItem(Trigger);
	//
	//// Bonus to hacking stat Effect
	////
	//PersistentStatChangeEffect = new class'X2Effect_PersistentStatChange';
	//PersistentStatChangeEffect.BuildPersistentEffect(1, true, false, false);
	//PersistentStatChangeEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, false, , Template.AbilitySourceName);
	//PersistentStatChangeEffect.AddPersistentStatChange(eStat_Offense, default.UNCANNY_BONUS);
	//Template.AddTargetEffect(PersistentStatChangeEffect);
//
	//Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
//
	//return Template;	
//}


static function X2AbilityTemplate Warp()
{
	local X2AbilityTemplate                 Template;
	local X2AbilityCost_ActionPoints        ActionPointCost;
	local X2Condition_UnitProperty          UnitPropertyCondition;
	local X2Effect_ApplyWeaponDamage        WeaponDamageEffect, BonusDamageEffect;
	local X2AbilityCooldown_Bonus                 Cooldown;
	local X2Effect_Reave					ReaveEffect;
	local X2Condition_AbilityProperty		ConsumeCondition, DevastateCondition;
	local X2Effect_AdditionalAnimSets						AnimSets;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_Warp');

	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;  //non-turn ender
	Template.AbilityCosts.AddItem(ActionPointCost);
	Template.ShotHUDPriority = class'UIUtilities_Tactical'.const.CLASS_SQUADDIE_PRIORITY;

	Cooldown = new class'X2AbilityCooldown_Bonus';
	Cooldown.iNumTurns = default.WARP_COOLDOWN;
	Cooldown.iModifier = 1;
	Cooldown.ModifierAbility = 'RM_BioticNerves';
	Template.AbilityCooldown = Cooldown;

	Template.AbilityToHitCalc = default.DeadEye;


	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	Template.AddShooterEffectExclusions();

	Template.AbilityTargetConditions.AddItem(default.LivingHostileTargetProperty);	
	Template.AbilityTargetConditions.AddItem(default.GameplayVisibilityCondition);

	WeaponDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	WeaponDamageEffect.bIgnoreBaseDamage = true;
	WeaponDamageEffect.DamageTag = 'RM_Warp';
	Template.AddTargetEffect(WeaponDamageEffect);

	// Add missing animation sequences
	// HL_TeleportStart HL_TeleportStop
	AnimSets = new class'X2Effect_AdditionalAnimSets';
	AnimSets.AddAnimSetWithPath("Perk_Biotic_Generic.AS_GenericBiotic");
	AnimSets.BuildPersistentEffect(1, false, false, false);
	//AnimSets.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, false, , Template.AbilitySourceName);
	Template.AddShooterEffect(AnimSets);

	ReaveEffect = new class'X2Effect_Reave';
	ReaveEffect.BaseShieldHPIncrease = default.REAVE_BASE;
	ReaveEffect.IsMinorReave = true;
	ConsumeCondition = new class'X2Condition_AbilityProperty';
	ConsumeCondition.OwnerHasSoldierAbilities.AddItem('RM_ConsumingBiotics');
	ReaveEffect.TargetConditions.AddItem(ConsumeCondition);
	Template.AddShooterEffect(ReaveEffect);

	BonusDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	BonusDamageEffect.bIgnoreBaseDamage = true;
	BonusDamageEffect.EffectDamageValue.Damage = 1;
	DevastateCondition = new class'X2Condition_AbilityProperty';
	DevastateCondition.OwnerHasSoldierAbilities.AddItem('RM_DevastatingBiotics');
	BonusDamageEffect.TargetConditions.AddItem(DevastateCondition);
	Template.AddTargetEffect(BonusDamageEffect);

	Template.AbilityTargetStyle = default.SimpleSingleTarget;
	Template.AbilityTriggers.AddItem(default.PlayerInputTrigger);
	Template.Hostility = eHostility_Offensive;

	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_crit";
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.bShowActivation = false;
	Template.CustomFireAnim = 'HL_Warp';

	Template.ActivationSpeech = 'Mindblast';

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;
	Template.CinescriptCameraType = "Psionic_FireAtUnit";

	Template.LostSpawnIncreasePerUse = class'X2AbilityTemplateManager'.default.MeleeLostSpawnIncreasePerUse;

	return Template;
}


static function X2AbilityTemplate Lance()
{
	local X2AbilityTemplate					Template;
	local X2AbilityMultiTarget_Line         LineMultiTarget;
	local X2Condition_UnitProperty          TargetCondition;
	local X2AbilityCost_ActionPoints        ActionCost;
	local X2Effect_ApplyWeaponDamage        DamageEffect, BonusDamageEffect;
	local X2AbilityCooldown_Bonus	Cooldown;
	local X2Effect_ApplyWeaponDamage    RuptureEffect;
	local X2Condition_AbilityProperty   ExposeCondition, DevastateCondition;
	local X2Effect_Reave					ReaveEffect;
	local X2Condition_AbilityProperty		ConsumeCondition;
	local X2AbilityToHitCalc_StandardAim    StandardAim;
	local X2Condition_Visibility                VisCondition;
	local X2Effect_AdditionalAnimSets						AnimSets;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_Lance');

	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.Hostility = eHostility_Offensive;
	Template.IconImage = "img:///XPerkIconPack.UIPerk_star_blossom";

	Template.CustomFireAnim = 'HL_Lance';
	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;
	Template.BuildInterruptGameStateFn = TypicalAbility_BuildInterruptGameState;

	ActionCost = new class'X2AbilityCost_ActionPoints';
	ActionCost.iNumPoints = 1;
	Template.AbilityCosts.AddItem(ActionCost);


	Cooldown = new class'X2AbilityCooldown_Bonus';
	Cooldown.iNumTurns = default.LANCE_COOLDOWN;
	Cooldown.iModifier = 1;
	Cooldown.ModifierAbility = 'RM_BioticNerves';
	Template.AbilityCooldown = Cooldown;


	Template.AbilityTriggers.AddItem(default.PlayerInputTrigger);	
	StandardAim = new class'X2AbilityToHitCalc_StandardAim';
	StandardAim.BuiltInHitMod = 20;
	Template.AbilityToHitCalc = StandardAim;
	Template.AbilityToHitOwnerOnMissCalc = StandardAim;

	Template.AbilityTargetStyle = default.SimpleSingleTarget;

	VisCondition = new class'X2Condition_Visibility';
	VisCondition.bRequireGameplayVisible = true;
	VisCondition.bActAsSquadsight = true;
	Template.AbilityTargetConditions.AddItem(VisCondition);
	Template.AbilityTargetConditions.AddItem(default.LivingHostileTargetProperty);

	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	Template.AddShooterEffectExclusions();

	TargetCondition = new class'X2Condition_UnitProperty';
	TargetCondition.ExcludeFriendlyToSource = false;
	TargetCondition.ExcludeDead = true;
	Template.AbilityTargetConditions.AddItem(TargetCondition);

	DamageEffect = new class'X2Effect_ApplyWeaponDamage';
	DamageEffect.bIgnoreBaseDamage = true;
	DamageEffect.DamageTag = 'RM_Lance';
	Template.AddTargetEffect(DamageEffect);

	RuptureEffect = new class'X2Effect_ApplyWeaponDamage';
	RuptureEffect.bIgnoreBaseDamage = true;
	RuptureEffect.bIgnoreArmor = true;
	RuptureEffect.EffectDamageValue.Rupture = default.Exposure_Rupture;
	ExposeCondition = new class'X2Condition_AbilityProperty';
	ExposeCondition.OwnerHasSoldierAbilities.AddItem('RM_ExposingBiotics');
	RuptureEffect.TargetConditions.AddItem(ExposeCondition);
	Template.AddTargetEffect(RuptureEffect);

	// Add missing animation sequences
	// HL_TeleportStart HL_TeleportStop
	AnimSets = new class'X2Effect_AdditionalAnimSets';
	AnimSets.AddAnimSetWithPath("Perk_Biotic_Generic.AS_GenericBiotic");
	AnimSets.BuildPersistentEffect(1, false, false, false);
	//AnimSets.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, false, , Template.AbilitySourceName);
	Template.AddShooterEffect(AnimSets);

	ReaveEffect = new class'X2Effect_Reave';
	ReaveEffect.BaseShieldHPIncrease = default.REAVE_BASE;
	ReaveEffect.IsMinorReave = true;
	ConsumeCondition = new class'X2Condition_AbilityProperty';
	ConsumeCondition.OwnerHasSoldierAbilities.AddItem('RM_ConsumingBiotics');
	ReaveEffect.TargetConditions.AddItem(ConsumeCondition);
	Template.AddShooterEffect(ReaveEffect);

	BonusDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	BonusDamageEffect.bIgnoreBaseDamage = true;
	BonusDamageEffect.EffectDamageValue.Damage = 1;
	DevastateCondition = new class'X2Condition_AbilityProperty';
	DevastateCondition.OwnerHasSoldierAbilities.AddItem('RM_DevastatingBiotics');
	BonusDamageEffect.TargetConditions.AddItem(DevastateCondition);
	Template.AddTargetEffect(BonusDamageEffect);

	Template.CinescriptCameraType = "Psionic_FireAtUnit";

	Template.ActivationSpeech = 'NullLance';
	Template.LostSpawnIncreasePerUse = class'X2AbilityTemplateManager'.default.StandardShotLostSpawnIncreasePerUse;
	//Template.bOverrideAim = true;
	//Template.bUseSourceLocationZToAim = true;

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;

	return Template;
}

static function X2AbilityTemplate Reave()
{
	local X2AbilityTemplate                 Template;
	local X2AbilityCost_ActionPoints        ActionPointCost;
	local X2Condition_UnitProperty          TargetProperty;
	local X2Effect_ApplyWeaponDamage        WeaponDamageEffect;
	local X2AbilityCooldown_Bonus                 Cooldown;
	local X2Effect_Reave					ReaveEffect;
	local X2Condition_AbilityProperty   ExposeCondition, DevastateCondition;
	local X2Effect_ApplyWeaponDamage    RuptureEffect, BonusDamageEffect;
	local X2Effect_AdditionalAnimSets						AnimSets;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_Reave');

	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;  
	ActionPointCost.bConsumeAllPoints = true;
	ActionPointCost.DoNotConsumeAllEffects.AddItem('RM_BioticOverdrive');
	Template.AbilityCosts.AddItem(ActionPointCost);
	Template.ShotHUDPriority = class'UIUtilities_Tactical'.const.CLASS_SQUADDIE_PRIORITY;

	Cooldown = new class'X2AbilityCooldown_Bonus';
	Cooldown.iNumTurns = default.REAVE_COOLDOWN;
	Cooldown.iModifier = 1;
	Cooldown.ModifierAbility = 'RM_BioticNerves';
	Template.AbilityCooldown = Cooldown;

	Template.AbilityToHitCalc = default.DeadEye;

	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	Template.AddShooterEffectExclusions();

	Template.AbilityTargetConditions.AddItem(default.LivingHostileTargetProperty);
	Template.AbilityTargetConditions.AddItem(default.GameplayVisibilityCondition);

	WeaponDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	WeaponDamageEffect.bIgnoreBaseDamage = true;
	WeaponDamageEffect.DamageTag = 'RM_Reave';
	Template.AddTargetEffect(WeaponDamageEffect);

	ReaveEffect = new class'X2Effect_Reave';
	ReaveEffect.BaseShieldHPIncrease = default.REAVE_BASE;
	ReaveEffect.ReaveShieldHPDivisor = default.REAVE_BONUS;
	ReaveEffect.AmpMGShieldHPBonus = default.REAVE_MAG;
	ReaveEffect.AmpBMShieldHPBonus = default.REAVE_BEAM;
	Template.AddShooterEffect(ReaveEffect);

	RuptureEffect = new class'X2Effect_ApplyWeaponDamage';
	RuptureEffect.bIgnoreBaseDamage = true;
	RuptureEffect.bIgnoreArmor = true;
	RuptureEffect.EffectDamageValue.Rupture = default.Exposure_Rupture;
	ExposeCondition = new class'X2Condition_AbilityProperty';
	ExposeCondition.OwnerHasSoldierAbilities.AddItem('RM_ExposingBiotics');
	RuptureEffect.TargetConditions.AddItem(ExposeCondition);
	Template.AddTargetEffect(RuptureEffect);

	BonusDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	BonusDamageEffect.bIgnoreBaseDamage = true;
	BonusDamageEffect.EffectDamageValue.Damage = 1;
	DevastateCondition = new class'X2Condition_AbilityProperty';
	DevastateCondition.OwnerHasSoldierAbilities.AddItem('RM_DevastatingBiotics');
	BonusDamageEffect.TargetConditions.AddItem(DevastateCondition);
	Template.AddTargetEffect(BonusDamageEffect);

	// Add missing animation sequences
	// HL_TeleportStart HL_TeleportStop
	AnimSets = new class'X2Effect_AdditionalAnimSets';
	AnimSets.AddAnimSetWithPath("Perk_Biotic_Generic.AS_GenericBiotic");
	AnimSets.BuildPersistentEffect(1, false, false, false);
	//AnimSets.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, false, , Template.AbilitySourceName);
	Template.AddShooterEffect(AnimSets);

	Template.AbilityTargetStyle = default.SimpleSingleTarget;
	Template.AbilityTriggers.AddItem(default.PlayerInputTrigger);
	Template.Hostility = eHostility_Offensive;

	Template.IconImage = "img:///XPerkIconPack.UIPerk_revive_crit";
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.bShowActivation = false;
	Template.CustomFireAnim = 'HL_Reave';

	Template.ActivationSpeech = 'Mindblast';

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;
	Template.CinescriptCameraType = "Psionic_FireAtUnit";
	Template.LostSpawnIncreasePerUse = class'X2AbilityTemplateManager'.default.StandardShotLostSpawnIncreasePerUse;

	return Template;
}


static function X2AbilityTemplate Singularity()
{
	local X2AbilityTemplate                 Template;
	local X2AbilityCost_ActionPoints        ActionPointCost;
	local X2Condition_UnitProperty          UnitPropertyCondition;
	local X2Condition_UnitEffects           UnitEffectsCondition;
	local X2AbilityCooldown_Bonus					Cooldown;
	local X2Effect_Singularity_RMPsi       SingularityEffect;
	local X2Effect_PerkAttachForFX			DurationFXEffect;
	local X2Effect_TriggerEvent				EndDurationFXEffect;
	local X2AbilityTarget_Cursor			CursorTarget;
	//local X2AbilityMultiTarget_Radius		RadiusMultiTarget;
	local X2AbilityMultiTarget_Radius_RMPsi RadiusMultiTarget;
	local X2Condition_UnitType				UnitGroupCondition;
	local X2Effect_RemoveOverwatch_RMPsi	ActionPointsEffect;
	local X2Effect_RemoveEffects			SingularityRemoveEffects;
	local X2Condition_UnitStatCheck         ShieldCondition, ArmorCondition;
	local X2Effect_ApplyWeaponDamage        WeaponDamageEffect;
	local X2Condition_AbilityProperty   ExposeCondition, DevastateCondition;
	local X2Effect_ApplyWeaponDamage    RuptureEffect, BonusDamageEffect;
	local X2Effect_Reave					ReaveEffect;
	local X2Condition_AbilityProperty		ConsumeCondition;
	local X2Condition_AbilityProperty   ExplodingCondition;
	local X2Effect_Persistent               DisorientedEffect;
	local X2Condition_UnitProperty						SourceNotConcealedCondition;
	local X2Effect_AdditionalAnimSets						AnimSets;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_Singularity');
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_psi_rift";
	//Template.IconImage = "img:///LEBPsi_Misc.Textures.UIPerk_psi_singularity";
	Template.AbilitySourceName = 'eAbilitySource_psionic';
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.Hostility = eHostility_Offensive;
	Template.ShotHUDPriority = class'UIUtilities_Tactical'.const.CLASS_COLONEL_PRIORITY;

	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;
	//ActionPointCost.iNumPoints = 0;
	ActionPointCost.bConsumeAllPoints = true;
	ActionPointCost.DoNotConsumeAllEffects.AddItem('RM_BioticOverdrive');
	Template.AbilityCosts.AddItem(ActionPointCost);


	Cooldown = new class'X2AbilityCooldown_Bonus';
	//Cooldown.iNumTurns = 0;
	Cooldown.iNumTurns = default.SINGULARITY_COOLDOWN;
	Cooldown.iModifier = 1;
	Cooldown.ModifierAbility = 'RM_BioticNerves';
	Template.AbilityCooldown = Cooldown;

	// Source cannot be dead
	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	Template.AddShooterEffectExclusions();

	//Don't trigger when the source is concealed
	SourceNotConcealedCondition = new class'X2Condition_UnitProperty';
	SourceNotConcealedCondition.ExcludeConcealed = true;
	Template.AbilityShooterConditions.AddItem(SourceNotConcealedCondition);
	

	UnitPropertyCondition = new class'X2Condition_UnitProperty';
	UnitPropertyCondition.ExcludeDead = true;
	UnitPropertyCondition.ExcludeRobotic = false;
	UnitPropertyCondition.ExcludeAlien = false;
	UnitPropertyCondition.ExcludeInStasis = true;
	UnitPropertyCondition.ExcludeFriendlyToSource = false;
	UnitPropertyCondition.FailOnNonUnits = true;
	UnitPropertyCondition.ExcludeTurret = true;
	Template.AbilityMultiTargetConditions.AddItem(UnitPropertyCondition);

	// This Target cannot already be bound
	UnitEffectsCondition = new class'X2Condition_UnitEffects';
	//UnitEffectsCondition.AddExcludeEffect(class'X2AbilityTemplateManager'.default.BoundName, 'AA_UnitIsBound');
	//UnitEffectsCondition.AddExcludeEffect(class'X2Ability_CarryUnit'.default.CarryUnitEffectName, 'AA_CarryingUnit');
	UnitEffectsCondition.AddExcludeEffect(class'X2StatusEffects'.default.UnconsciousName, 'AA_UnitImpaired');
	Template.AbilityMultiTargetConditions.AddItem(UnitEffectsCondition);

	UnitGroupCondition = new class'X2Condition_UnitType';
	UnitGroupCondition.ExcludeTypes.AddItem('Sectopod');
	UnitGroupCondition.ExcludeTypes.AddItem('AdventPsiWitch');
	UnitGroupCondition.ExcludeTypes.AddItem('Gatekeeper');
	Template.AbilityMultiTargetConditions.AddItem(UnitGroupCondition);
	
	CursorTarget = new class'X2AbilityTarget_Cursor';
	CursorTarget.bRestrictToSquadsightRange = true;
	CursorTarget.FixedAbilityRange = default.SINGULARITY_RANGE;
	Template.AbilityTargetStyle = CursorTarget;

	RadiusMultiTarget = new class'X2AbilityMultiTarget_Radius_RMPsi';
	RadiusMultiTarget.fTargetRadius = default.SINGULARITY_RADIUS;
	RadiusMultiTarget.bIgnoreBlockingCover = true;
	RadiusMultiTarget.bAllowDeadMultiTargetUnits = false;
	RadiusMultiTarget.PsiMulti = default.SINGULARITY_PSIMULTI;
	RadiusMultiTarget.MinRadius = default.SINGULARITY_MINRADIUS;
	RadiusMultiTarget.MaxRadius = default.SINGULARITY_MAXRADIUS;
	Template.AbilityMultiTargetStyle = RadiusMultiTarget;

	X2AbilityMultiTarget_Radius(Template.AbilityMultiTargetStyle).AddAbilityBonusRadius('RM_ExplodingBiotics', class'RM_Helpers'.default.RadiiBonus);

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTriggers.AddItem(default.PlayerInputTrigger);

	//remove suppression and overwatch
	SingularityRemoveEffects = new class'X2Effect_RemoveEffects';
	SingularityRemoveEffects.EffectNamesToRemove.AddItem('Suppression');
	SingularityRemoveEffects.EffectNamesToRemove.AddItem('AreaSuppression');
	//SingularityRemoveEffects.EffectNamesToRemove.AddItem(class'X2Ability_CarryUnit'.default.CarryUnitEffectName);
	//SingularityRemoveEffects.EffectNamesToRemove.AddItem(class'X2AbilityTemplateManager'.default.BeingCarriedEffectName);
	//SingularityRemoveEffects.EffectNamesToRemove.AddItem(class'X2AbilityTemplateManager'.default.BoundName);
	//SingularityRemoveEffects.EffectNamesToRemove.AddItem(class'X2Ability_Viper'.default.BindSustainedEffectName);
	SingularityRemoveEffects.bCheckSource = true;
	Template.AddMultiTargetEffect(SingularityRemoveEffects);

	//SingularityRemoveEffects = new class'X2Effect_RemoveEffects';
	//SingularityRemoveEffects.EffectNamesToRemove.AddItem(class'X2Ability_Viper'.default.BindSustainedEffectName);
	//Template.AddMultiTargetEffect(SingularityRemoveEffects);
	Template.AddMultiTargetEffect(new class'X2Effect_RemoveViperBind_RMPsi');
	

	ActionPointsEffect = new class'X2Effect_RemoveOverwatch_RMPsi';
	Template.AddMultiTargetEffect(ActionPointsEffect);

	SingularityEffect = new class'X2Effect_Singularity_RMPsi';
	// Singularity effect will not proc on armoured or shielded units
	ShieldCondition = new class'X2Condition_UnitStatCheck';
	ShieldCondition.AddCheckStat(eStat_ShieldHP, 1, eCheck_LessThan);
	SingularityEffect.TargetConditions.AddItem(ShieldCondition);
	ArmorCondition = new class'X2Condition_UnitStatCheck';
	ArmorCondition.AddCheckStat(eStat_ArmorMitigation, 1, eCheck_LessThan);
	SingularityEffect.TargetConditions.AddItem(ArmorCondition);
	Template.AddMultiTargetEffect(SingularityEffect);

	WeaponDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	WeaponDamageEffect.bIgnoreBaseDamage = true;
	WeaponDamageEffect.DamageTag = 'Singularity';
	Template.AddMultiTargetEffect(WeaponDamageEffect);

	RuptureEffect = new class'X2Effect_ApplyWeaponDamage';
	RuptureEffect.bIgnoreBaseDamage = true;
	RuptureEffect.bIgnoreArmor = true;
	RuptureEffect.EffectDamageValue.Rupture = default.Exposure_Rupture;
	ExposeCondition = new class'X2Condition_AbilityProperty';
	ExposeCondition.OwnerHasSoldierAbilities.AddItem('RM_ExposingBiotics');
	RuptureEffect.TargetConditions.AddItem(ExposeCondition);
	Template.AddMultiTargetEffect(RuptureEffect);

	ReaveEffect = new class'X2Effect_Reave';
	ReaveEffect.BaseShieldHPIncrease = default.REAVE_BASE;
	ReaveEffect.IsMinorReave = true;
	ConsumeCondition = new class'X2Condition_AbilityProperty';
	ConsumeCondition.OwnerHasSoldierAbilities.AddItem('RM_ConsumingBiotics');
	ReaveEffect.TargetConditions.AddItem(ConsumeCondition);
	Template.AddShooterEffect(ReaveEffect);

	BonusDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	BonusDamageEffect.bIgnoreBaseDamage = true;
	BonusDamageEffect.EffectDamageValue.Damage = 1;
	DevastateCondition = new class'X2Condition_AbilityProperty';
	DevastateCondition.OwnerHasSoldierAbilities.AddItem('RM_DevastatingBiotics');
	BonusDamageEffect.TargetConditions.AddItem(DevastateCondition);
	Template.AddMultiTargetEffect(BonusDamageEffect);


	// On hit effects
	//  Stunned effect for 1 or 2 unblocked hit
	DisorientedEffect = class'X2StatusEffects'.static.CreateDisorientedStatusEffect(, , false);
	ExplodingCondition = new class'X2Condition_AbilityProperty';
	ExplodingCondition.OwnerHasSoldierAbilities.AddItem('RM_ExplodingBiotics');
	DisorientedEffect.TargetConditions.AddItem(ExplodingCondition);
	Template.AddMultiTargetEffect(DisorientedEffect);


	DurationFXEffect = new class 'X2Effect_PerkAttachForFX';
	DurationFXEffect.BuildPersistentEffect(1, false, true, , eGameRule_PlayerTurnEnd);
	DurationFXEffect.EffectName = default.SingularityDurationFXEffectName;
	Template.AddShooterEffect(DurationFXEffect);
	EndDurationFXEffect = new class'X2Effect_TriggerEvent';
	EndDurationFXEffect.TriggerEventName = default.EndSingularityDurationFXEventName;
	Template.AddShooterEffect(EndDurationFXEffect);


	// Add missing animation sequences
	// HL_TeleportStart HL_TeleportStop
	AnimSets = new class'X2Effect_AdditionalAnimSets';
	AnimSets.AddAnimSetWithPath("Perk_Biotic_Generic.AS_GenericBiotic");
	AnimSets.BuildPersistentEffect(1, false, false, false);
	//AnimSets.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, false, , Template.AbilitySourceName);
	Template.AddShooterEffect(AnimSets);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;
	Template.BuildVisualizationFn = Singularity_BuildVisualization;

	Template.BuildInterruptGameStateFn = TypicalAbility_BuildInterruptGameState;
	Template.CustomFireAnim = 'HL_BigSingularity';
	//Template.bSkipFireAction = true;
	//Template.TargetingMethod = class'X2TargetingMethod_VoidRift';
	Template.TargetingMethod = class'X2TargetingMethod_Singularity_RMPsi';
	Template.ActivationSpeech = 'VoidRift';
	Template.CinescriptCameraType = "Psionic_FireAtLocation";
	Template.AdditionalAbilities.AddItem('RM_SingularityEndDurationFX');
	Template.LostSpawnIncreasePerUse = class'X2AbilityTemplateManager'.default.StandardShotLostSpawnIncreasePerUse;
	return Template;
}

simulated function Singularity_BuildVisualization(XComGameState VisualizeGameState)
{
	local XComGameStateHistory History;
	local XComGameStateContext_Ability Context;
	local StateObjectReference InteractingUnitRef;
	//local VisualizationTrack EmptyTrack;
	//local VisualizationTrack ShooterTrack, BuildTrack;
	local VisualizationActionMetadata EmptyTrack, ActionMetadata, BuildTrack;
	local XComGameStateVisualizationMgr VisualizationMgr;
	local XComGameState_Unit Shooter;
	local XComGameState_Effect EffectState;
	local int i, j;
	//local int TrackIndex;
	local X2VisualizerInterface TargetVisualizerInterface;
	local Actor TargetVisualizer;
	local bool bSelfTarget;
	local X2Effect_Persistent Effect;
	local name EffectApplyResult;
	local X2Action ExitCoverAction;

	History = `XCOMHISTORY;
	VisualizationMgr = `XCOMVISUALIZATIONMGR;

	Context = XComGameStateContext_Ability(VisualizeGameState.GetContext());
	InteractingUnitRef = Context.InputContext.SourceObject; 
	
	//Configure the visualization track for the shooter
	//****************************************************************************************
	//ShooterTrack = EmptyTrack;
	//ShooterTrack.StateObject_OldState = History.GetGameStateForObjectID(InteractingUnitRef.ObjectID, eReturnType_Reference, VisualizeGameState.HistoryIndex - 1);
	//ShooterTrack.StateObject_NewState = VisualizeGameState.GetGameStateForObjectID(InteractingUnitRef.ObjectID);
	//ShooterTrack.TrackActor = History.GetVisualizer(InteractingUnitRef.ObjectID);
//
	ActionMetadata.StateObject_OldState = History.GetGameStateForObjectID(InteractingUnitRef.ObjectID, eReturnType_Reference, VisualizeGameState.HistoryIndex - 1);
	ActionMetadata.StateObject_NewState = VisualizeGameState.GetGameStateForObjectID(InteractingUnitRef.ObjectID);
	ActionMetadata.VisualizeActor = History.GetVisualizer(InteractingUnitRef.ObjectID);


	Shooter = XComGameState_Unit(ActionMetadata.StateObject_NewState);
	if(Shooter != none)
	{
	//class'X2Action_AbilityPerkStart'.static.AddToVisualizationTrack(ShooterTrack, Context);
	//class'X2Action_ExitCover'.static.AddToVisualizationTrack(ShooterTrack, Context);
	//
//
	ExitCoverAction = class'X2Action_ExitCover'.static.AddToVisualizationTree(ActionMetadata, Context);

		//If we were interrupted, insert a marker node for the interrupting visualization code to use. In the move path version above, it is expected for interrupts to be 
		//done during the move.
		if (Context.InterruptionStatus != eInterruptionStatus_None)
		{
			//Insert markers for the subsequent interrupt to insert into
			class'X2Action'.static.AddInterruptMarkerPair(ActionMetadata, Context, ExitCoverAction);
		}
		class'X2Action_Fire'.static.AddToVisualizationTree(ActionMetadata, Context);
	}

	for( i = 0; i < Context.InputContext.MultiTargets.Length; ++i )
	{
		InteractingUnitRef = Context.InputContext.MultiTargets[i];

		if(InteractingUnitRef == Shooter.GetReference() )
		{
			bSelfTarget = true;
		}
	}
	If(!bSelfTarget) class'X2Action_EnterCover'.static.AddToVisualizationTree(ActionMetadata, Context);
	//class'X2Action_AbilityPerkEnd'.static.AddToVisualizationTrack(ShooterTrack, Context);

	// Configure the visualization track for the multi targets
	//******************************************************************************************
	for( i = 0; i < Context.InputContext.MultiTargets.Length; ++i )
	{
		InteractingUnitRef = Context.InputContext.MultiTargets[i];

		if( InteractingUnitRef == Shooter.GetReference() )
		{
			BuildTrack = ActionMetaData;
		}
		else
		{
			BuildTrack = EmptyTrack;
			BuildTrack.StateObject_OldState = History.GetGameStateForObjectID(InteractingUnitRef.ObjectID, eReturnType_Reference, VisualizeGameState.HistoryIndex - 1);
			BuildTrack.StateObject_NewState = VisualizeGameState.GetGameStateForObjectID(InteractingUnitRef.ObjectID);
			BuildTrack.VisualizeActor = History.GetVisualizer(InteractingUnitRef.ObjectID);
		}

		if( InteractingUnitRef != Shooter.GetReference() )
		{
			class'X2Action_WaitForAbilityEffect'.static.AddToVisualizationTree(BuildTrack, Context);
		}

		for( j = 0; j < Context.ResultContext.MultiTargetEffectResults[i].Effects.Length; ++j )
		{
			Context.ResultContext.MultiTargetEffectResults[i].Effects[j].AddX2ActionsForVisualization(VisualizeGameState, BuildTrack, Context.ResultContext.MultiTargetEffectResults[i].ApplyResults[j]);
		}

		TargetVisualizerInterface = X2VisualizerInterface(BuildTrack.VisualizeActor);
		if( TargetVisualizerInterface != none )
		{
			//Allow the visualizer to do any custom processing based on the new game state. For example, units will create a death action when they reach 0 HP.
			TargetVisualizerInterface.BuildAbilityEffectsVisualization(VisualizeGameState, BuildTrack);
		}

		//OutVisualizationTracks.AddItem(BuildTrack);
	}

	//OutVisualizationTracks.AddItem(ShooterTrack);

	foreach VisualizeGameState.IterateByClassType(class'XComGameState_Effect', EffectState)
    {
        if (EffectState.bRemoved)
        {
            TargetVisualizer = History.GetVisualizer(EffectState.ApplyEffectParameters.TargetStateObjectRef.ObjectID);
 
            BuildTrack = EmptyTrack;
            BuildTrack.VisualizeActor = TargetVisualizer;
            BuildTrack.StateObject_OldState = History.GetGameStateForObjectID(EffectState.ApplyEffectParameters.TargetStateObjectRef.ObjectID, eReturnType_Reference, VisualizeGameState.HistoryIndex - 1);
            BuildTrack.StateObject_NewState = VisualizeGameState.GetGameStateForObjectID(EffectState.ApplyEffectParameters.TargetStateObjectRef.ObjectID);
 
            Effect = EffectState.GetX2Effect();
            EffectApplyResult = Context.FindTargetEffectApplyResult(Effect);
            Effect.AddX2ActionsForVisualization_Removed(VisualizeGameState, BuildTrack, EffectApplyResult, EffectState);
 
            //OutVisualizationTracks.AddItem(BuildTrack);
        }
    }   
}



static function X2AbilityTemplate SingularityEndDurationFX()
{
	local X2AbilityTemplate             Template;
	local X2Effect_RemoveEffects        VoidRiftRemoveEffects;
	//local X2Effect_Dummy_LEBPsi			DummyEffect;
	local X2AbilityTrigger_EventListener EventListener;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_SingularityEndDurationFX');
	
	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	
	EventListener = new class'X2AbilityTrigger_EventListener';
	EventListener.ListenerData.EventID = default.EndSingularityDurationFXEventName;
	EventListener.ListenerData.Deferral = ELD_OnStateSubmitted;
	EventListener.ListenerData.Filter = eFilter_Unit;
	EventListener.ListenerData.EventFn = class'XComGameState_Ability'.static.AbilityTriggerEventListener_Self;
	EventListener.ListenerData.Priority = 1;
	Template.AbilityTriggers.AddItem(EventListener);

	//DummyEffect = new class'X2Effect_Dummy_LEBPsi';
	//Template.AddShooterEffect(DummyEffect);
	//Template.AddTargetEffect(DummyEffect);
	VoidRiftRemoveEffects = new class'X2Effect_RemoveEffects';
	VoidRiftRemoveEffects.EffectNamesToRemove.AddItem(default.SingularityDurationFXEffectName);
	Template.AddShooterEffect(VoidRiftRemoveEffects);
	
	Template.bSkipFireAction = true;
	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;
	
	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_insanity";
	Template.ShotHUDPriority = class'UIUtilities_Tactical'.const.CLASS_CORPORAL_PRIORITY;
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;
	
	return Template;
}

DefaultProperties
{
	EndSingularityDurationFXEventName="EndBioticSingularityDurationFXEvent"
	SingularityDurationFXEffectName="BioticSingularityDurationFXEffect"
}